from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''
    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

INVESTOR_KEY = ''

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f"/quota_lock/investor/{INVESTOR_KEY}/quota_lock"
method = "POST"

body = {
    "type": "collateral",
    "collateral": {
        "recipient": {
            "name": "Sample Recipient Name",
            "document_number": "000.000.000-00",
            "person_type": "legal_person",
            "legal_person": {
                "activity_code": "00.00-0-00",
                "representatives": [
                    {
                        "name": "Sample Recipient Representative Name",
                        "document_number": "000.000.000-00",
                    }
                ],
            }
        },
        "borrower": {
            "name": "Sample Borrower Name",
            "document_number": "000.000.000-00",
            "person_type": "legal_person",
            "legal_person": {
                "activity_code": "00.00-0-00",
                "representatives": [
                    {
                        "name": "Sample Borrower Representative Name",
                        "document_number": "000.000.000-00",
                    }
                ],
            }
        },
        "assets": [
            {
                "asset_type": "cce",
                "credit_operation": {
                    "contract_number": "1000000001",
                    "principal_value": 0.0,
                    "interest_rate_type": "post_fixed",
                    "pre_fixed": {
                        "monthly_rate": 0.0,
                        "calendar_base": "calendar_360",
                    },
                    "post_fixed": {
                        "calendar_base": "workdays",
                        "indexer": "di",
                        "rate": 1,
                        "lag": {
                           "reference": "daily",
                           "amount": 1
                        },
                    },
                },
            },
        ],
        "issuance_series": [
            {
                "issuance_serie_key": "UUID",
                "number_of_quotas": 0.00,
                "financial_value": 0.00,
            },
            {
                "issuance_serie_key": "UUID",
                "number_of_quotas": 0.00,
                "financial_value": 0.00,
            },
        ],
        "bank_account_key": "UUID"
    },
}

encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.post(url=url, headers=headers, json=body)
print(resp.json())

